// 12个问题数据
const questionsData = {
    work: {
        text: '工作压力大，感觉快撑不住了',
        questionAudio: 'audio/work_question.mp3',
        answer: {
            classic: '兵贵胜，不贵久。',
            modern: '工作要追求效率，不要拖拖拉拉。压力大时，先完成最重要的事，别让小事拖累你。'
        },
        answerAudio: 'audio/work_answer.mp3',
        emoji: 'images/临时抱佛脚.png',
        blessing: '送你临时抱佛脚符，祝你工作顺利，效率翻倍！'
    },
    friend: {
        text: '和朋友闹矛盾了，不知道怎么办',
        questionAudio: 'audio/friend_question.mp3',
        answer: {
            classic: '知己知彼，百战不殆。',
            modern: '了解朋友的立场，也了解自己的需求。沟通时换位思考，矛盾自然化解。'
        },
        answerAudio: 'audio/friend_answer.mp3',
        emoji: null,
        blessing: '愿你友谊长存，矛盾化解！'
    },
    study: {
        text: '学习总是三分钟热度，坚持不下去',
        questionAudio: null,
        answer: {
            classic: '不战而屈人之兵，善之善者也。',
            modern: '最好的学习是找到方法，而不是硬拼。制定小目标，每天进步一点点，比三分钟热度强百倍。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你学习有恒，日日精进！'
    },
    decision: {
        text: '面临重要选择，不知道如何决定',
        questionAudio: null,
        answer: {
            classic: '多算胜，少算不胜。',
            modern: '做决定前多思考，权衡利弊。列出选项的优缺点，答案自然浮现。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你做出明智选择！'
    },
    conflict: {
        text: '生活中总是遇到小麻烦',
        questionAudio: 'audio/conflict_question.mp3',
        answer: {
            classic: '兵无常势，水无常形。',
            modern: '遇到问题先冷静分析，找到解决方法。记住，困难是暂时的，灵活应对，办法总比问题多。'
        },
        answerAudio: 'audio/conflict_answer.mp3',
        emoji: 'images/锦鲤附体.png',
        blessing: '送你锦鲤附体符，祝你麻烦全消，好运连连！'
    },
    money: {
        text: '总是存不下钱，花钱如流水',
        questionAudio: 'audio/money_question.mp3',
        answer: {
            classic: '多算胜，少算不胜。',
            modern: '理财要精打细算，做好预算。记账是第一步，知道钱花在哪里，才能存下钱。'
        },
        answerAudio: 'audio/money_answer.mp3',
        emoji: 'images/招财进宝.png',
        blessing: '送你招财进宝符，祝你财源滚滚，存钱有方！'
    },
    health: {
        text: '身体总是很累，感觉亚健康',
        questionAudio: null,
        answer: {
            classic: '以逸待劳，以饱待饥。',
            modern: '身体是革命的本钱。规律作息，适度运动，合理饮食，让身体恢复活力。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你身体健康，精力充沛！'
    },
    family: {
        text: '和家人沟通有障碍，总是吵架',
        questionAudio: null,
        answer: {
            classic: '上兵伐谋，其次伐交。',
            modern: '和家人沟通，先理解再表达。用温和的方式沟通，比争吵更有效。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你家庭和睦，沟通顺畅！'
    },
    dream: {
        text: '有梦想但不知道如何实现',
        questionAudio: null,
        answer: {
            classic: '千里之行，始于足下。',
            modern: '梦想需要行动。把大目标拆成小步骤，每天完成一点，梦想就会越来越近。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你梦想成真，步步为营！'
    },
    anxiety: {
        text: '总是焦虑不安，担心未来',
        questionAudio: null,
        answer: {
            classic: '投之亡地然后存，陷之死地然后生。',
            modern: '焦虑源于对未来的担忧。专注当下，做好眼前事，未来自然会好起来。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你心静如水，未来可期！'
    },
    competition: {
        text: '竞争激烈，感觉压力很大',
        questionAudio: null,
        answer: {
            classic: '知己知彼，百战不殆。',
            modern: '了解对手，更要了解自己。发挥自己的优势，在竞争中脱颖而出。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你在竞争中脱颖而出！'
    },
    motivation: {
        text: '缺乏动力，做什么都提不起劲',
        questionAudio: null,
        answer: {
            classic: '三军可夺帅也，匹夫不可夺志也。',
            modern: '找到你真正想要的东西，那就是你的动力。从小事做起，找回那份热情。'
        },
        answerAudio: null,
        emoji: null,
        blessing: '祝你重拾动力，充满激情！'
    }
};

// 问题顺序
const questionOrder = ['work', 'friend', 'study', 'decision', 'conflict', 'money', 'health', 'family', 'dream', 'anxiety', 'competition', 'motivation'];

// 当前问题索引
let currentQuestionIndex = 0;
let displayedQuestions = [];

// DOM元素
const chatMessages = document.getElementById('chatMessages');
const chatOptions = document.getElementById('chatOptions');
const optionButtons = document.querySelectorAll('.option-btn');
const refreshBtn = document.getElementById('refreshBtn');
const leftCharacter = document.querySelector('.character-left');
const rightCharacter = document.querySelector('.character-right');
const leftOverlay = leftCharacter.querySelector('.character-overlay');
const rightOverlay = rightCharacter.querySelector('.character-overlay');
const startDialogBtn = document.getElementById('startDialogBtn');
const startDialogContainer = document.getElementById('startDialogContainer');
const chatContainer = document.getElementById('chatContainer');

// 初始化
function init() {
    // 绑定开启对话按钮事件
    if (startDialogBtn) {
        startDialogBtn.addEventListener('click', startDialog);
    }
    
    // 初始隐藏聊天容器
    if (chatContainer) {
        chatContainer.classList.remove('show');
    }
}

// 开启对话
function startDialog() {
    // 隐藏开启对话按钮
    if (startDialogContainer) {
        startDialogContainer.classList.add('hide');
        setTimeout(() => {
            startDialogContainer.style.display = 'none';
        }, 500);
    }
    
    // 确保标题栏保持显示
    const chatHeader = document.querySelector('.chat-header');
    if (chatHeader) {
        chatHeader.classList.add('show');
    }
    
    // 显示聊天容器
    if (chatContainer) {
        chatContainer.classList.add('show');
    }
    
    // 初始化聊天功能
    displayNextQuestions();
    refreshBtn.addEventListener('click', handleRefresh);
    optionButtons.forEach((btn, index) => {
        btn.addEventListener('click', () => handleQuestionClick(index));
    });
}

// 显示下一组问题（每组3个）
function displayNextQuestions() {
    displayedQuestions = [];
    
    // 如果问题全部显示完毕，重置索引开始循环
    if (currentQuestionIndex >= questionOrder.length) {
        currentQuestionIndex = 0;
    }
    
    for (let i = 0; i < 3; i++) {
        if (currentQuestionIndex >= questionOrder.length) {
            // 如果循环到末尾，重新开始
            currentQuestionIndex = 0;
        }
        
        const questionKey = questionOrder[currentQuestionIndex];
        displayedQuestions.push(questionKey);
        optionButtons[i].textContent = questionsData[questionKey].text;
        optionButtons[i].disabled = false;
        currentQuestionIndex++;
    }
    
    // 换一换按钮始终可用
    refreshBtn.disabled = false;
    refreshBtn.textContent = '换一换';
    
    // 显示所有按钮
    for (let i = 0; i < displayedQuestions.length; i++) {
        optionButtons[i].style.display = 'block';
    }
}

// 处理换一换
function handleRefresh() {
    displayNextQuestions();
}

// 处理问题点击
async function handleQuestionClick(index) {
    if (index >= displayedQuestions.length) return;
    
    const questionKey = displayedQuestions[index];
    const question = questionsData[questionKey];
    
    // 禁用所有按钮
    optionButtons.forEach(btn => btn.disabled = true);
    refreshBtn.disabled = true;
    
    // 1. 显示问题消息（右对齐）
    addUserMessage(question.text);
    
    // 2. 播放提问者音频
    if (question.questionAudio) {
        await playAudio(question.questionAudio);
    }
    // 确保用户说话动画在音频播放完成后停止
    resetUserCharacter();
    
    // 3. 显示孙武回答（2条消息）
    addSunwuMessage(question.answer.classic);
    await sleep(500);
    addSunwuMessage(question.answer.modern);
    
    // 4. 播放孙武回答音频（1.2倍速）
    if (question.answerAudio) {
        await playAudio(question.answerAudio, 1.2);
    }
    // 确保孙武说话动画在音频播放完成后停止
    resetSunwuCharacter();
    
    // 5. 显示表情包和祝福语
    if (question.emoji) {
        await sleep(500);
        addEmojiMessage(question.emoji);
    }
    await sleep(500);
    addSunwuMessage(question.blessing);
    await sleep(1000);
    
    // 6. 恢复人物站立图
    resetCharacters();
    
    // 重新启用按钮
    optionButtons.forEach(btn => btn.disabled = false);
    refreshBtn.disabled = false;
}

// 添加用户消息
function addUserMessage(text) {
    rightCharacter.classList.add('talking');
    rightOverlay.classList.add('active');
    
    const messageDiv = document.createElement('div');
    messageDiv.className = 'message user';
    
    const avatarDiv = document.createElement('div');
    avatarDiv.className = 'message-avatar';
    avatarDiv.textContent = '我';
    
    const contentDiv = document.createElement('div');
    contentDiv.className = 'message-content';
    contentDiv.textContent = text;
    
    messageDiv.appendChild(avatarDiv);
    messageDiv.appendChild(contentDiv);
    chatMessages.appendChild(messageDiv);
    
    scrollToBottom();
}

// 添加孙武消息
function addSunwuMessage(text) {
    leftCharacter.classList.add('talking');
    leftOverlay.classList.add('active');
    
    const messageDiv = document.createElement('div');
    messageDiv.className = 'message sunwu';
    
    const avatarImg = document.createElement('img');
    avatarImg.className = 'message-avatar';
    avatarImg.src = 'images/sunwutouxiang.jpg';
    avatarImg.alt = '孙武';
    
    const contentDiv = document.createElement('div');
    contentDiv.className = 'message-content';
    contentDiv.textContent = text;
    
    messageDiv.appendChild(avatarImg);
    messageDiv.appendChild(contentDiv);
    chatMessages.appendChild(messageDiv);
    
    scrollToBottom();
}

// 添加表情包消息
function addEmojiMessage(emojiPath) {
    const messageDiv = document.createElement('div');
    messageDiv.className = 'message sunwu emoji';
    
    const avatarImg = document.createElement('img');
    avatarImg.className = 'message-avatar';
    avatarImg.src = 'images/sunwutouxiang.jpg';
    avatarImg.alt = '孙武';
    
    const contentDiv = document.createElement('div');
    contentDiv.className = 'message-content';
    
    const emojiImg = document.createElement('img');
    emojiImg.src = emojiPath;
    emojiImg.alt = '表情包';
    emojiImg.addEventListener('click', () => showEmojiModal(emojiPath));
    
    contentDiv.appendChild(emojiImg);
    
    messageDiv.appendChild(avatarImg);
    messageDiv.appendChild(contentDiv);
    chatMessages.appendChild(messageDiv);
    
    scrollToBottom();
}

// 播放音频
function playAudio(audioPath, playbackRate = 1.0) {
    return new Promise((resolve, reject) => {
        const audio = new Audio(audioPath);
        audio.playbackRate = playbackRate; // 设置播放速度
        audio.onended = () => resolve();
        audio.onerror = () => resolve(); // 即使出错也继续
        audio.play().catch(() => resolve()); // 如果播放失败也继续
    });
}

// 恢复用户人物站立图
function resetUserCharacter() {
    rightOverlay.classList.remove('active');
    rightCharacter.classList.remove('talking');
}

// 恢复孙武人物站立图
function resetSunwuCharacter() {
    leftOverlay.classList.remove('active');
    leftCharacter.classList.remove('talking');
}

// 恢复所有人物站立图
function resetCharacters() {
    resetUserCharacter();
    resetSunwuCharacter();
}

// 滚动到底部
function scrollToBottom() {
    setTimeout(() => {
        chatMessages.scrollTop = chatMessages.scrollHeight;
    }, 100);
}

// 睡眠函数
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

// 显示表情包大图模态框
function showEmojiModal(emojiPath) {
    const modal = document.getElementById('emojiModal');
    const modalImage = document.getElementById('emojiModalImage');
    modalImage.src = emojiPath;
    modal.classList.add('active');
    
    // 阻止背景滚动
    document.body.style.overflow = 'hidden';
}

// 关闭表情包大图模态框
function closeEmojiModal() {
    const modal = document.getElementById('emojiModal');
    modal.classList.remove('active');
    
    // 恢复背景滚动
    document.body.style.overflow = '';
}

// 处理入场动画
function handleIntroAnimation() {
    const introVideo = document.getElementById('introVideo');
    const introVideoContainer = document.getElementById('introVideoContainer');
    const mainContent = document.getElementById('mainContent');
    
    if (!introVideo || !introVideoContainer || !mainContent) {
        // 如果没有视频元素，直接显示主内容
        if (mainContent) {
            mainContent.classList.add('show');
        }
        return;
    }
    
    // 添加时间戳参数强制刷新视频（避免缓存）
    const videoSource = introVideo.querySelector('source');
    if (videoSource) {
        const originalSrc = videoSource.getAttribute('src');
        const separator = originalSrc.includes('?') ? '&' : '?';
        videoSource.setAttribute('src', originalSrc + separator + 't=' + Date.now());
        introVideo.load(); // 重新加载视频
    }
    
    // 监听视频播放完成
    introVideo.addEventListener('ended', () => {
        // 添加减淡出场动画
        introVideoContainer.classList.add('fade-out');
        
        // 动画完成后显示主内容并移除视频容器
        setTimeout(() => {
            mainContent.classList.add('show');
            
            // 先显示标题栏
            const chatHeader = document.querySelector('.chat-header');
            if (chatHeader) {
                chatHeader.classList.add('show');
            }
            
            // 延迟显示开启对话按钮
            setTimeout(() => {
                if (startDialogContainer) {
                    startDialogContainer.style.display = 'flex';
                }
            }, 500); // 标题栏显示后0.5秒显示按钮
            
            // 延迟移除视频容器，确保动画完成
            setTimeout(() => {
                introVideoContainer.remove();
            }, 1000);
        }, 500); // 在减淡动画进行一半时开始显示主内容，实现流畅衔接
    });
    
    // 如果视频加载失败或无法播放，直接显示主内容
    introVideo.addEventListener('error', () => {
        introVideoContainer.style.display = 'none';
        mainContent.classList.add('show');
        
        // 先显示标题栏
        const chatHeader = document.querySelector('.chat-header');
        if (chatHeader) {
            chatHeader.classList.add('show');
        }
        
        // 延迟显示开启对话按钮
        setTimeout(() => {
            if (startDialogContainer) {
                startDialogContainer.style.display = 'flex';
            }
        }, 500);
    });
    
    // 监听视频可以播放时自动播放
    introVideo.addEventListener('canplay', () => {
        introVideo.play().catch(() => {
            // 如果自动播放失败，直接显示主内容
            introVideoContainer.style.display = 'none';
            mainContent.classList.add('show');
            
            // 先显示标题栏
            const chatHeader = document.querySelector('.chat-header');
            if (chatHeader) {
                chatHeader.classList.add('show');
            }
            
            // 延迟显示开启对话按钮
            setTimeout(() => {
                if (startDialogContainer) {
                    startDialogContainer.style.display = 'flex';
                }
            }, 500);
        });
    });
    
    // 尝试立即播放视频（某些浏览器需要用户交互才能自动播放）
    introVideo.play().catch(() => {
        // 如果自动播放失败，等待视频加载完成后再尝试
        // canplay 事件会处理
    });
}

// 页面加载完成后初始化
document.addEventListener('DOMContentLoaded', () => {
    // 先处理入场动画
    handleIntroAnimation();
    
    // 初始化主功能（延迟执行，等待动画完成）
    setTimeout(() => {
        init();
    }, 100);
    
    // 绑定模态框关闭事件
    const modal = document.getElementById('emojiModal');
    const closeBtn = modal.querySelector('.emoji-modal-close');
    
    closeBtn.addEventListener('click', closeEmojiModal);
    
    // 点击背景关闭模态框
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            closeEmojiModal();
        }
    });
    
    // ESC键关闭模态框
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal.classList.contains('active')) {
            closeEmojiModal();
        }
    });
});

